<?php
namespace Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagImportExport\SwagImportExportVersion2;

/**
 * Copy of Shopware SwagImportExport DataDbAdapter in Version 2.12.1
 */
interface SwagDataDbAdapter
{
    const ARTICLE_ADAPTER = 'articles';
    const ARTICLE_IMAGE_ADAPTER = 'articlesImages';
    const ARTICLE_INSTOCK_ADAPTER = 'articlesInStock';
    const ARTICLE_TRANSLATION_ADAPTER = 'articlesTranslations';
    const ARTICLE_PRICE_ADAPTER = 'articlesPrices';
    const CATEGORIES_ADAPTER = 'categories';
    const CATEGORIES_TRANSLATION_ADAPTER = 'categoriesTranslations';
    const ORDER_ADAPTER = 'orders';
    const MAIN_ORDER_ADAPTER = 'mainOrders';
    const CUSTOMER_ADAPTER = 'customers';
    const CUSTOMER_COMPLETE_ADAPTER = 'customersComplete';
    const NEWSLETTER_RECIPIENTS_ADAPTER = 'newsletter';
    const TRANSLATION_ADAPTER = 'translations';
    const ADDRESS_ADAPTER = 'addresses';

    /**
     * Reads all records with the given ids and selects the passed columns.
     *
     * @param array $ids
     * @param array $columns
     *
     * @return array<string, mixed>
     */
    public function read($ids, $columns);

    /**
     * Returns all ids for the given export with the given parameters.
     *
     * @param int                  $start
     * @param int                  $limit
     * @param array<string, mixed> $filter
     *
     * @return array<int>
     */
    public function readRecordIds($start, $limit, $filter);

    /**
     * Returns the default column.
     *
     * @return array<string>
     *@see SwagDataDbAdapter::getColumns()
     *
     */
    public function getDefaultColumns();

    /**
     * Returns all iteration nodes, i.e. for articles it configuratiors, similar, ...
     *
     * @return array<array<string>>
     */
    public function getSections();

    /**
     * Returns all column names.
     *
     * @example:
     * [
     *  'address.id as id',
     *  'address.firstname as firstname'
     * ]
     *
     * @param string $section
     *
     * @return bool|mixed
     */
    public function getColumns($section);

    /**
     * Creates, updates and validates the imported records.
     *
     * @param array<string, mixed> $records
     *
     * @return void
     */
    public function write($records);

    /**
     * Returns unprocessed data. This will be used every time if an import wants to create data which relies on created data.
     * For instance article images, similar or accessory articles.
     *
     * @return array<mixed>
     */
    public function getUnprocessedData();

    /**
     * Returns all log messages as an array.
     *
     * @return array<string>
     */
    public function getLogMessages();

    /**
     * Returns true if log messages are available.
     *
     * @return string
     */
    public function getLogState();
}
