<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Controllers;

/**
 * Controller class that is used for ExtJS SubApplications.
 */
class ViisonCommonBaseController extends \Shopware_Controllers_Backend_ExtJs
{
    /**
     * Overwrite the loading of SubApplications by Shopware.
     *
     * The actual loading of the SubApplication happens in `\Shopware\Plugins\ViisonCommon\Subscriber\Common::onViewRendererFilterRender()`
     * We don't want Shopware to load anything here. Therefore an empty template string is loaded into the view.
     */
    public function indexAction()
    {
        /** @var \Enlight_View_Default $view */
        $view = $this->get('plugins')->get('Controller')->get('ViewRenderer')->Action()->View();
        $view->loadTemplate('snippet:string:');
    }

    /**
     * Override this method to return parameters that will be assigned to the Smarty view that is used for rendering
     * the JavaScript code.
     *
     * Note: If the app is NOT rendered using Smarty, the returned params are made available via the JavaScript
     *       'ViisonCommonAppConfigContainer' singleton.
     *
     * @return array
     */
    public function getViewParams()
    {
        return [];
    }

    /**
     * Override this method to return the names extra text snippet namespace that are required by the JavaScript code.
     *
     * Note: If the app is rendered using Smarty, this method will not be called.
     *
     * @return string[]
     */
    public function getExtraSnippetNamespaces()
    {
        return [];
    }
}
