<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Structs;

/**
 * Base class for all structs.
 */
// phpcs:ignore VIISON.Classes.AbstractClassName
abstract class Struct
{
    /**
     * Returns an array representation of all values
     * stored in the struct.
     *
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
