// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonGrid.selection.TabableCellModel', {

    extend: 'Ext.selection.CellModel',
    alias: 'selection.viisonCommonTabableCellModel',

    /**
     * @override
     *
     * Modifies the default behaviour of the cell selection model by allowing
     * the user to tab through all editable fields of the grid (not only of the current row)
     * in a linear manner.
     *
     * @param {object} editingPlugin
     * @param {object} e
     */
    onEditorTab: function (editingPlugin, e) {
        var direction = e.shiftKey ? 'left' : 'right';
        var position = this.move(direction, e);

        while (typeof position !== 'undefined' && !editingPlugin.startEditByPosition(position)) {
            position = this.move(direction, e);
        }
        this.wasEditing = (typeof position === 'undefined');
    },

});
