// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A form for editing the recipient, subject and content of an email.
 */
Ext.define('Shopware.apps.ViisonCommonMailComposer.view.Main', {

    extend: 'Ext.form.Panel',
    alias: 'widget.viison_common_mail_composer-main',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_mail_composer/main',

    flex: 1,
    border: false,
    bodyStyle: {
        border: 'none !important',
    },
    layout: {
        type: 'vbox',
        align: 'stretch',
    },

    /**
     * A flag that controls whether the attachment field is shown of hidden.
     */
    hideAttachmentField: false,

    /**
     * The main initializer adding view components.
     */
    initComponent: function () {
        // Add several input fields
        this.items = this.createItems();

        // Add a toolbar
        this.dockedItems = this.createDockedItems();

        this.callParent(arguments);
    },

    createItems: function () {
        return [{
            xtype: 'container',
            cls: 'is--header-container',
            layout: {
                type: 'vbox',
                align: 'stretch',
            },
            defaults: {
                allowBlank: false,
                labelWidth: 75,
                margin: '5px 0',
            },
            padding: '15 20 15 20',
            items: [
                {
                    xtype: 'textfield',
                    name: 'fromMail',
                    fieldLabel: '',
                    hidden: true,
                    value: (this.mail && this.mail.fromMail) ? this.mail.fromMail : '',
                    validate: function () {
                        return true;
                    },
                }, {
                    xtype: 'textfield',
                    name: 'fromName',
                    fieldLabel: '',
                    hidden: true,
                    value: (this.mail && this.mail.fromName) ? this.mail.fromName : '',
                    validate: function () {
                        return true;
                    },
                }, {
                    xtype: 'textfield',
                    name: 'toAddress',
                    fieldLabel: this.getViisonSnippet('main/fields/to'),
                    value: (this.mail && this.mail.toAddress) ? this.mail.toAddress : '',
                }, {
                    xtype: 'textfield',
                    name: 'subject',
                    fieldLabel: this.getViisonSnippet('main/fields/subject'),
                    value: (this.mail && this.mail.subject) ? this.mail.subject : '',
                }, {
                    xtype: 'textfield',
                    name: 'attachment',
                    fieldLabel: this.getViisonSnippet('main/fields/attachment'),
                    margin: '15 0 5 0',
                    value: (this.mail && this.mail.attachment) ? this.mail.attachment : '',
                    readOnly: true,
                    hidden: this.hideAttachmentField,
                    validate: function () {
                        return true;
                    },
                }, {
                    xtype: 'checkboxfield',
                    name: 'isHtml',
                    fieldLabel: '',
                    hidden: true,
                    inputValue: true,
                    checked: this.mail.isHtml,
                    uncheckedValue: this.mail.isHtml,
                },
            ],
        }, {
            xtype: (this.mail.isHtml) ? 'tinymcefield' : 'textarea',
            cls: 'is--mail-body-editor',
            name: (this.mail.isHtml) ? 'contentHtml' : 'content',
            value: (this.mail.isHtml) ? this.mail.contentHtml : this.mail.content,
            minHeight: 90,
            margin: (this.mail.isHtml) ? '0 0 10 0' : '0 0 0 0',
            flex: 1,
            editor: {
                theme_advanced_statusbar_location: 'none',
            },
        }];
    },

    createDockedItems: function () {
        return [{
            xtype: 'toolbar',
            dock: 'bottom',
            ui: 'shopware-ui',
            cls: 'is--viison-common--button-panel',
            items: this.createToolbarItems(),
        }];
    },

    createToolbarItems: function () {
        return [{
            xtype: 'tbfill',
        }, {
            text: this.getViisonSnippet('main/buttons/cancel'),
            cls: 'secondary',
            action: 'cancel',
            scope: this,
            handler: function () {
                this.fireEvent('cancel', this);
            },
        }, {
            text: this.getViisonSnippet('main/buttons/send'),
            cls: 'primary',
            scope: this,
            handler: function () {
                this.fireEvent('sendMail', this);
            },
        }];
    },

});
