<?php
/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

namespace SwagSecurity\Components\Model;

use Doctrine\Common\EventManager;
use Doctrine\DBAL\Connection;
use Doctrine\ORM\ORMException;
use Shopware\Components\Model\Configuration;
use Shopware\Components\Model\ModelManager as BaseModelManager;
use Shopware\Components\Model\QueryOperatorValidator;

/**
 * Global Manager which is responsible for initializing the adapter classes.
 */
class ModelManager extends BaseModelManager
{
    /**
     * @var QueryOperatorValidator
     */
    protected $operatorValidator;

    public function __construct(
        Connection $conn,
        Configuration $config,
        QueryOperatorValidator $operatorValidator,
        EventManager $eventManager = null
    ) {
        $this->operatorValidator = $operatorValidator;
        parent::__construct($conn, $config, $eventManager);
    }

    public static function createInstance(
        Connection $conn,
        Configuration $config,
        EventManager $eventManager = null,
        QueryOperatorValidator $operatorValidator = null
    ) {
        if (!$config->getMetadataDriverImpl()) {
            throw ORMException::missingMappingDriverImpl();
        }

        if ($eventManager !== null && $conn->getEventManager() !== $eventManager) {
            throw ORMException::mismatchedEventManager();
        }

        if ($operatorValidator === null) {
            $operatorValidator = new QueryOperatorValidator();
        }

        return new self($conn, $config, $operatorValidator, $conn->getEventManager());
    }

    /**
     * @return \Doctrine\ORM\QueryBuilder|QueryBuilder
     */
    public function createQueryBuilder()
    {
        return new QueryBuilder($this, new QueryOperatorValidator());
    }
}
