<?php

/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

namespace Shopware\Plugins\SwagSecurity\Components;

class ShopwareVersion
{
    /**
     * Helper method useful when a new patch needs to be developed, as non-released versions contain the ___VERSION___
     * string the developer can set the class constant TEST_VERSION to a version of his own preference in order
     * to test the newly added security patch with the version of his own preference.
     *
     * NOTE: For release/production set the class constant TEST_VERSION to null
     *
     * @param string $type Parameter which indicated which version to get from the version string, full, major or minor
     *
     * @throws \Exception if the request version type is invalid
     *
     * @return string
     */
    public static function get($type = 'full')
    {
        $version = Shopware()->Config()->get('version');

        if ($version === '___VERSION___') {
            $msg = 'Please define the shopware constant named VERSION at engine/Shopware/Application.php or if not available engine/Shopware/Kernel.php';
            throw new \LogicException($msg);
        }

        switch ($type) {
            case 'full':
                return $version;
            case 'major':
                return substr($version, 0, strpos($version, '.'));
            case 'minor':
                return substr($version, 0, strrpos($version, '.'));
            default:
                throw new \Exception(sprintf('Unknown requested version type "%s"', $type));
        }
    }
}
