<?php
/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

use Shopware\Bundle\PluginInstallerBundle\Context\PluginsByTechnicalNameRequest;

class Shopware_Controllers_Backend_SwagSecurityUpdate extends Shopware_Controllers_Backend_ExtJs
{
    public function infoAction()
    {
        $req = new PluginsByTechnicalNameRequest($this->getLocale(), '__VERSION__', array('SwagSecurity'));
        $store = $this->container->get('shopware_plugininstaller.plugin_service_store_production')->getPlugin($req);

        if (!$store) {
            return;
        }

        $currentVersion = $this->container->get('dbal_connection')->fetchColumn('SELECT `version` FROM s_core_plugins WHERE name = "SwagSecurity"');

        $plugin = $store->jsonSerialize();
        $plugin['updateAvailable'] = version_compare($plugin['version'], $currentVersion, '>');

        $usefulChangelogs = array();
        foreach ($plugin['changelog'] as $changelog) {
            if (version_compare($currentVersion, $changelog['version'], '<')) {
                $usefulChangelogs[] = $changelog;
            }
        }

        $plugin['changelog'] = $usefulChangelogs;

        $this->View()->assign($plugin);
    }

    private function getLocale()
    {
        return $this->container->get('auth')->getIdentity()->locale->getLocale();
    }
}
