// {namespace name="backend/newsletter_manager/main"}

// {block name="backend/newsletter_manager/controller/editor"}
// {$smarty.block.parent}
Ext.override(Shopware.apps.NewsletterManager.controller.Editor, {
    onOpenPreview: function() {
        var me = this,
            newsletter = me.createNewsletterModel();

        newsletter.set('status', -1);
        newsletter.set('id', null);

        newsletter.save({
            callback: function(data, operation) {
                var records = operation.getRecords(),
                    record = records[0],
                    rawData = record.getProxy().getReader().rawData;
                if (operation.success) {
                    if (!Ext.isEmpty(rawData.data)) {
                        // Open up a iframe and show the preview
                        var pos = location.href.search('/backend');
                        var url = location.href.substr(0, pos) + '/backend/Newsletter/view?id=' + rawData.data.id;

                        new Ext.Window({
                            title: '{s name=preview}Preview: {/s} ' + newsletter.get('subject'),
                            width: 940,
                            height: 600,
                            layout: 'fit',
                            items: [{
                                xtype: 'component',
                                id: 'iframe-win',
                                autoEl: {
                                    tag: 'iframe',
                                    src: url,
                                    sandbox: ''
                                }
                            }]
                        }).show();
                    }
                } else {
                    if (rawData && rawData.data) {
                        Shopware.Notification.createGrowlMessage(me.snippets.saveNewsletter.errorTitle, me.snippets.saveNewsletter.errorMessage + '\r\n<br />' + rawData.data, me.snippets.growl);
                        return;
                    }
                    Shopware.Notification.createGrowlMessage(me.snippets.saveNewsletter.errorTitle, me.snippets.saveNewsletter.errorMessage, me.snippets.growl);
                }
            }
        });
    }
})
//{/block}
