
// {block name="backend/customer/view/customer_stream/preview"}
// {$smarty.block.parent}
Ext.override(Shopware.apps.Customer.view.customer_stream.Preview, {
    getColumns: function () {

        var columns = this.callParent(arguments);

        Ext.Array.forEach(columns, function (column) {
            if (column.dataIndex === 'lastname') {
                column.renderer = function (v, meta, record) {
                    var names = [
                        record.get('title'),
                        record.get('firstname'),
                        record.get('lastname')
                    ];

                    var name = '<b>' + names.join(' ') + '</b>';
                    var age = '';
                    if (record.get('age')) {
                        age = ' (' + record.get('age') + ')';
                    }
                    var company = '';
                    if (record.get('company')) {
                        company = '<br>' + record.get('company') + '';
                    }

                    var mail = Ext.String.format('<a href="mailto:[0]" data-qtip="[0]">[0]</a>', Ext.util.Format.htmlEncode(record.get('email')));

                    return name + age + company + '<br>' + mail;
                };
            }
        })

        return columns;
    }
})
// {/block}
