// {block name="backend/index/application"}
// {$smarty.block.parent}
Ext.override(Ext.String, {
    /**
     * @var DOMParser _domParser
     */
    _domParser: new DOMParser(),

    /**
     * Return the text content of the element
     *
     * @returns string
     */
    getText: function(value) {
        var me = this;

        if (!value) {
            return '';
        }

        var elementNodes = me._domParser
            .parseFromString(Ext.String.format('<div>[0]</div>', value), "text/html")
            .documentElement
            .querySelectorAll('div');

        return me._getText(elementNodes);
    }
});
// {/block}
