//{namespace name="backend/index/security"}
//{block name="backend/index/controller/widgets"}
//{$smarty.block.parent}
        Ext.define('Shopware.window.ExpiredSecurityPlugin', {
            extend: 'Enlight.app.Window',
            autoScroll: true,
            layout: 'fit',
            height: 430,
            width: 870,
            autoShow: true,
            title: '{s name="WindowTitle"}{/s}',
            footerButton: false,
            changelog: [],

            initComponent: function() {
                var me = this;

                me.on('close', function () {
                    me.setCookie();
                });

                me.items = [
                    {
                        xtype: 'form',
                        layout: 'fit',
                        items: [me.createContentPage()],
                        dockedItems: [{
                            xtype: 'toolbar',
                            dock: 'bottom',
                            ui: 'shopware-ui',
                            cls: 'shopware-toolbar',
                            items: me.getWindowButtons()
                        }]
                    },
                ];

                me.callParent(arguments);
            },

            createContentPage: function () {
                return {
                    xtype: 'container',
                    autoScroll: true,
                    html: '{literal}<style>.plugin-window { color: #475C6A; } .plugin-window h2 { color: #495B67;font-weight: bold;font-size: 24px;margin-bottom: 20px } .plugin-window h3 { color: #495B67;font-weight: bold;font-size: 18px; } .plugin-window p { margin-bottom: 20px;line-height: 140%;} .plugin-window img { width: calc(100% - 100px);padding: 50px;margin-top: 40px;position: absolute;top: 50%;left: 50%;transform: translateX(-50%); } .plugin-window .bar { width: 50%;float: left;position: relative; } .plugin-window .bar:last-child { margin-left: 50%; } .plugin-window strong { font-weight: bold; }</style>{/literal}<div class="plugin-window"><div class="bar"><img src="' + this.getImage() + '"></div><div class="bar"><div style="margin-top: 50px;margin-right: 30px;">' + this.getText() + '</div></div></div>'
                }
            },

            getImage: function() {
                return '{link file="backend/swag_security/warning.svg"}';
            },

            getText: function() {
                var text = '<br><br><h3>Changelog:</h3><br>';
                this.changelog.forEach(function (item) {
                    text = text + '<strong>Version: ' + item.version + '</strong>' + item.text + '';
                });

                return '{s name="WindowText"}{/s}' + text;
            },

            setCookie: function() {
                var currentDate = new Date();
                currentDate.setDate(currentDate.getDate() + 1);
                Ext.util.Cookies.set('checkedForSecurityUpdates', 1, currentDate);
            },

            getWindowButtons: function() {
                var me = this;

                return [
                    '->',
                    {
                        xtype: 'button',
                        text: '{s name="WindowCancel"}{/s}',
                        cls: 'secondary',
                        handler: function () {
                            me.setCookie();
                            me.destroy();
                        }
                    },
                    {
                        xtype: 'button',
                        text: '{s name="WindowUpdate"}{/s}',
                        cls: 'primary',
                        handler: function () {
                            me.setCookie();
                            me.destroy();
                            Shopware.app.Application.addSubApplication({
                                name: 'Shopware.apps.PluginManager',
                                params: {
                                    displayPlugin: 'SwagSecurity'
                                }
                            });
                        }
                    }
                ];
            }
        });

        Ext.override(Shopware.apps.Index.controller.Main, {
            init: function() {
                this.callParent(arguments);

                if (Ext.util.Cookies.get('checkedForSecurityUpdates')) {
                    return;
                }

                // We are too fast for the backend
                setTimeout(function () {
                    Ext.Ajax.request({
                        url: '{url controller=SwagSecurityUpdate action=info}',
                        success: function (response) {
                            response = JSON.parse(response.responseText);

                            if (response.updateAvailable) {
                                Ext.create('Shopware.window.ExpiredSecurityPlugin', {
                                    changelog: response.changelog
                                });
                            }
                        }
                    });
                }, 300);
            }
        });
//{/block}