CSRF.allowedDomains = [
    window.location.protocol + '//' + window.location.hostname
];
CSRF.isLocalLink = function (link) {
    if (link === undefined || link === null || link[0] === '/') {
        return true;
    }

    for (var index in this.allowedDomains) {
        if (link.indexOf(this.allowedDomains[index]) === 0) {
            return true;
        }
    }

    return false;
};

$.subscribe('plugin/swCsrfProtection/init', function () {
    $(document).ajaxSend(function (event, request, settings) {
        if (CSRF.isLocalLink(settings.url)) {
            return;
        }

        request.setRequestHeader('x-csrf-token', 'invalid');
    });
});