<?php

/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

use Rector\Config\RectorConfig;
use Rector\Core\ValueObject\PhpVersion;
use Rector\Set\ValueObject\DowngradeSetList;
use Rector\Set\ValueObject\SetList;

return static function (RectorConfig $rectorConfig) {
    // here we can define, what sets of rules will be applied
    // tip: use "SetList" class to autocomplete sets

    $rectorConfig->paths(array(__DIR__ . '/Components', __DIR__ . '/Controllers', __DIR__ . '/Engine', __DIR__ . '/Exception', __DIR__ . '/Snippets', __DIR__ . '/Tests', __DIR__ . '/Views'));

    $rectorConfig->sets(array(
        DowngradeSetList::PHP_74,
        DowngradeSetList::PHP_73,
        DowngradeSetList::PHP_72,
        DowngradeSetList::PHP_71,
        DowngradeSetList::PHP_70,
        DowngradeSetList::PHP_56,
        DowngradeSetList::PHP_54,
    ));

    $rectorConfig->phpVersion(PhpVersion::PHP_56);
};
